**************************************************************************
*Replication Stata code
*Article: Survey response in RDD-sampling SMS-invitation web-push study
*Author: Sebastian Kocar, University of Tasmania
**************************************************************************

clear
cls

***1) Uploading data to study response (survey outcomes and data collection characteristics)

u "...\Replication data - response.dta"

*Review of data

tab1 progress participated participated_status stage invitation ///
invitation_detailed stratification_info reminder day time sms

*1a) Information for Table 3

*Distribution by survey outcomes: interviews, partial interviews, breakoffs

tab participated_status invitation_detailed 

*Distribution of numbers by stratification information (unknown eligibility)

tab stratification_info invitation_detailed if participated_status==0

*Distribution of numbers by stratification information (all)

tab stratification_info invitation_detailed

*1b) Information for Table 4

*Review of outcome variable

tab participated

*Review of covariates

tab1 day time sms reminder stratification_info invitation

*Binary ligistic regression analysis (reference groups: no incentives, pinged numbers
*no SMS reminder, weekday, evening, SMS communicating benefits)

logit participated ib5.invitation ib3.stratification_info i.reminder ib2.day ib2.time i.sms

*1c) Information for Figure 3

*Predictive margins for combinations of response maximization solutions
 
margins i.invitation#i.stratification_info#reminder i.reminder

*******************

clear
cls

***2) Uploading data to study representation (Survey on Wellbeing, Health, and Life in general)

u "...\Replication data - representation.dta"

*2a) Information for Table 5

*Review of all variables for replication

tab1 Progress Q15 Q16 Q17 Q18 Q19 Q20 Q23

*Distribution for sex

tab Q15

*Distribution for age (group)

tab Q16

*Distribution for education

tab1 Q17 Q18 Q19

*Recoding education variable (for comparative purposes, to OPBS samples)

recode Q19 (1=1) (2/4=2) (5/9=3), gen(edu)

recode edu (.=1) if Q17<=5 

label define edu_label ///
1"Secondary Education or Cert I/II" ///
2 "Cert III/IV, (Advanced) Diploma " ///
3 "Bachelor’s degree or higher"
label values edu edu_label

tab edu

*Distribution for country of birth

tab Q23

*Distribution for region

tab Q20
